/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.r2dbc.core;

import io.r2dbc.spi.Readable;
import io.r2dbc.spi.ReadableMetadata;
import java.lang.reflect.Constructor;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.TypeConverter;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.r2dbc.core.BeanPropertyRowMapper;

public class DataClassRowMapper<T>
extends BeanPropertyRowMapper<T> {
    private final Constructor<T> mappedConstructor;
    private final String[] constructorParameterNames;
    private final TypeDescriptor[] constructorParameterTypes;

    public DataClassRowMapper(Class<T> mappedClass) {
        this(mappedClass, DefaultConversionService.getSharedInstance());
    }

    public DataClassRowMapper(Class<T> mappedClass, ConversionService conversionService) {
        super(mappedClass, conversionService);
        this.mappedConstructor = BeanUtils.getResolvableConstructor(mappedClass);
        int paramCount = this.mappedConstructor.getParameterCount();
        for (String name : this.constructorParameterNames = paramCount > 0 ? BeanUtils.getParameterNames(this.mappedConstructor) : new String[]{}) {
            this.suppressProperty(name);
        }
        this.constructorParameterTypes = new TypeDescriptor[paramCount];
        for (int i = 0; i < paramCount; ++i) {
            this.constructorParameterTypes[i] = new TypeDescriptor(new MethodParameter(this.mappedConstructor, i));
        }
    }

    @Override
    protected T constructMappedInstance(Readable readable, List<? extends ReadableMetadata> itemMetadatas, TypeConverter tc) {
        Object[] args = new Object[this.constructorParameterNames.length];
        for (int i = 0; i < args.length; ++i) {
            String name = this.constructorParameterNames[i];
            int index = this.findIndex(itemMetadatas, this.lowerCaseName(name));
            if (index == -1) {
                index = this.findIndex(itemMetadatas, this.underscoreName(name));
            }
            if (index == -1) {
                throw new DataRetrievalFailureException("Unable to map constructor parameter '" + name + "' to a column or out-parameter");
            }
            TypeDescriptor td = this.constructorParameterTypes[i];
            Object value = this.getItemValue(readable, index, td.getType());
            args[i] = tc.convertIfNecessary(value, td.getType(), td);
        }
        return (T)BeanUtils.instantiateClass(this.mappedConstructor, (Object[])args);
    }

    private int findIndex(List<? extends ReadableMetadata> itemMetadatas, String name) {
        int index = 0;
        for (ReadableMetadata readableMetadata : itemMetadatas) {
            if (readableMetadata.getName().equalsIgnoreCase(name)) {
                return index;
            }
            ++index;
        }
        return -1;
    }
}

