/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.util.Assert;

public final class JwtIssuedAtValidator
implements OAuth2TokenValidator<Jwt> {
    private final boolean required;
    private Duration clockSkew = Duration.ofSeconds(60L);
    private Clock clock = Clock.systemUTC();

    public JwtIssuedAtValidator() {
        this(false);
    }

    public JwtIssuedAtValidator(boolean required) {
        this.required = required;
    }

    public OAuth2TokenValidatorResult validate(Jwt jwt) {
        Assert.notNull((Object)jwt, (String)"jwt cannot be null");
        Instant issuedAt = jwt.getIssuedAt();
        if (issuedAt == null && this.required) {
            OAuth2Error error = JwtIssuedAtValidator.createOAuth2Error("iat claim is required.");
            return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{error});
        }
        if (issuedAt != null) {
            Instant now = Instant.now(this.clock);
            Instant notBefore = now.minus(this.clockSkew);
            Instant notAfter = now.plus(this.clockSkew);
            if (issuedAt.isBefore(notBefore) || issuedAt.isAfter(notAfter)) {
                OAuth2Error error = JwtIssuedAtValidator.createOAuth2Error("iat claim is invalid.");
                return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{error});
            }
        }
        return OAuth2TokenValidatorResult.success();
    }

    public void setClockSkew(Duration clockSkew) {
        Assert.notNull((Object)clockSkew, (String)"clockSkew cannot be null");
        Assert.isTrue((clockSkew.getSeconds() >= 0L ? 1 : 0) != 0, (String)"clockSkew must be >= 0");
        this.clockSkew = clockSkew;
    }

    public void setClock(Clock clock) {
        Assert.notNull((Object)clock, (String)"clock cannot be null");
        this.clock = clock;
    }

    private static OAuth2Error createOAuth2Error(String reason) {
        return new OAuth2Error("invalid_token", reason, null);
    }
}

