/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.config;

import io.r2dbc.spi.ConnectionFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.domain.ManagedTypes;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.r2dbc.convert.IdGeneratingEntityCallback;
import org.springframework.data.r2dbc.convert.MappingR2dbcConverter;
import org.springframework.data.r2dbc.convert.R2dbcConverter;
import org.springframework.data.r2dbc.convert.R2dbcCustomConversions;
import org.springframework.data.r2dbc.core.DefaultReactiveDataAccessStrategy;
import org.springframework.data.r2dbc.core.R2dbcEntityTemplate;
import org.springframework.data.r2dbc.core.ReactiveDataAccessStrategy;
import org.springframework.data.r2dbc.dialect.DialectResolver;
import org.springframework.data.r2dbc.dialect.R2dbcDialect;
import org.springframework.data.r2dbc.mapping.R2dbcMappingContext;
import org.springframework.data.relational.RelationalManagedTypes;
import org.springframework.data.relational.core.mapping.DefaultNamingStrategy;
import org.springframework.data.relational.core.mapping.NamingStrategy;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.mapping.Table;
import org.springframework.data.util.TypeScanner;
import org.springframework.lang.Nullable;
import org.springframework.r2dbc.core.DatabaseClient;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
public abstract class AbstractR2dbcConfiguration
implements ApplicationContextAware {
    private static final String CONNECTION_FACTORY_BEAN_NAME = "connectionFactory";
    @Nullable
    private ApplicationContext context;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    public abstract ConnectionFactory connectionFactory();

    protected Collection<String> getMappingBasePackages() {
        Package mappingBasePackage = this.getClass().getPackage();
        return Collections.singleton(mappingBasePackage == null ? null : mappingBasePackage.getName());
    }

    @Bean
    public RelationalManagedTypes r2dbcManagedTypes() throws ClassNotFoundException {
        return RelationalManagedTypes.fromIterable(this.getInitialEntitySet());
    }

    public R2dbcDialect getDialect(ConnectionFactory connectionFactory) {
        return DialectResolver.getDialect(connectionFactory);
    }

    @Bean(value={"r2dbcDatabaseClient", "databaseClient"})
    public DatabaseClient databaseClient() {
        ConnectionFactory connectionFactory = this.lookupConnectionFactory();
        return DatabaseClient.builder().connectionFactory(connectionFactory).bindMarkers(this.getDialect(connectionFactory).getBindMarkersFactory()).build();
    }

    @Bean
    public R2dbcEntityTemplate r2dbcEntityTemplate(DatabaseClient databaseClient, ReactiveDataAccessStrategy dataAccessStrategy) {
        Assert.notNull((Object)databaseClient, (String)"DatabaseClient must not be null");
        Assert.notNull((Object)dataAccessStrategy, (String)"ReactiveDataAccessStrategy must not be null");
        return new R2dbcEntityTemplate(databaseClient, dataAccessStrategy);
    }

    @Bean
    public R2dbcMappingContext r2dbcMappingContext(Optional<NamingStrategy> namingStrategy, R2dbcCustomConversions r2dbcCustomConversions, RelationalManagedTypes r2dbcManagedTypes) {
        Assert.notNull(namingStrategy, (String)"NamingStrategy must not be null");
        R2dbcMappingContext context = new R2dbcMappingContext(namingStrategy.orElse(DefaultNamingStrategy.INSTANCE));
        context.setSimpleTypeHolder(r2dbcCustomConversions.getSimpleTypeHolder());
        context.setManagedTypes((ManagedTypes)r2dbcManagedTypes);
        return context;
    }

    @Bean
    public IdGeneratingEntityCallback idGeneratingBeforeSaveCallback(RelationalMappingContext relationalMappingContext, DatabaseClient databaseClient) {
        return new IdGeneratingEntityCallback((MappingContext<RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty>)relationalMappingContext, this.getDialect(this.lookupConnectionFactory()), databaseClient);
    }

    @Bean
    public ReactiveDataAccessStrategy reactiveDataAccessStrategy(R2dbcConverter converter) {
        Assert.notNull((Object)converter, (String)"MappingContext must not be null");
        return new DefaultReactiveDataAccessStrategy(this.getDialect(this.lookupConnectionFactory()), converter);
    }

    @Bean
    public MappingR2dbcConverter r2dbcConverter(R2dbcMappingContext mappingContext, R2dbcCustomConversions r2dbcCustomConversions) {
        Assert.notNull((Object)((Object)mappingContext), (String)"MappingContext must not be null");
        return new MappingR2dbcConverter((MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty>)mappingContext, r2dbcCustomConversions);
    }

    @Bean
    public R2dbcCustomConversions r2dbcCustomConversions() {
        return new R2dbcCustomConversions(this.getStoreConversions(), this.getCustomConverters());
    }

    protected List<Object> getCustomConverters() {
        return Collections.emptyList();
    }

    protected CustomConversions.StoreConversions getStoreConversions() {
        R2dbcDialect dialect = this.getDialect(this.lookupConnectionFactory());
        ArrayList<Object> converters = new ArrayList<Object>(dialect.getConverters());
        converters.addAll(R2dbcCustomConversions.STORE_CONVERTERS);
        return CustomConversions.StoreConversions.of((SimpleTypeHolder)dialect.getSimpleTypeHolder(), converters);
    }

    ConnectionFactory lookupConnectionFactory() {
        String[] beanNamesForType;
        ApplicationContext context = this.context;
        Assert.notNull((Object)context, (String)"ApplicationContext is not yet initialized");
        for (String beanName : beanNamesForType = context.getBeanNamesForType(ConnectionFactory.class)) {
            if (!beanName.equals(CONNECTION_FACTORY_BEAN_NAME)) continue;
            return (ConnectionFactory)context.getBean(CONNECTION_FACTORY_BEAN_NAME, ConnectionFactory.class);
        }
        return this.connectionFactory();
    }

    protected Set<Class<?>> getInitialEntitySet() throws ClassNotFoundException {
        HashSet initialEntitySet = new HashSet();
        for (String basePackage : this.getMappingBasePackages()) {
            initialEntitySet.addAll(this.scanForEntities(basePackage));
        }
        return initialEntitySet;
    }

    protected Set<Class<?>> scanForEntities(String basePackage) {
        if (!StringUtils.hasText((String)basePackage)) {
            return Collections.emptySet();
        }
        return TypeScanner.typeScanner((ClassLoader)AbstractR2dbcConfiguration.class.getClassLoader()).forTypesAnnotatedWith(new Class[]{Table.class}).scanPackages(new String[]{basePackage}).collectAsSet();
    }
}

