/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.filter;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Set;
import org.springframework.boot.test.autoconfigure.filter.AnnotationCustomizableTypeExcludeFilter;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;

public abstract class StandardAnnotationCustomizableTypeExcludeFilter<A extends Annotation>
extends AnnotationCustomizableTypeExcludeFilter {
    private static final ComponentScan.Filter[] NO_FILTERS = new ComponentScan.Filter[0];
    private static final String[] FILTER_TYPE_ATTRIBUTES;
    private final MergedAnnotation<A> annotation;

    protected StandardAnnotationCustomizableTypeExcludeFilter(Class<?> testClass) {
        this.annotation = MergedAnnotations.from(testClass, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.INHERITED_ANNOTATIONS).get(this.getAnnotationType());
    }

    protected final MergedAnnotation<A> getAnnotation() {
        return this.annotation;
    }

    @Override
    protected boolean hasAnnotation() {
        return this.annotation.isPresent();
    }

    @Override
    protected ComponentScan.Filter[] getFilters(AnnotationCustomizableTypeExcludeFilter.FilterType type) {
        return this.annotation.getValue(FILTER_TYPE_ATTRIBUTES[type.ordinal()], ComponentScan.Filter[].class).orElse(NO_FILTERS);
    }

    @Override
    protected boolean isUseDefaultFilters() {
        return this.annotation.getValue("useDefaultFilters", Boolean.class).orElse(false);
    }

    @Override
    protected Set<Class<?>> getDefaultIncludes() {
        return Collections.emptySet();
    }

    @Override
    protected Set<Class<?>> getComponentIncludes() {
        return Collections.emptySet();
    }

    protected Class<A> getAnnotationType() {
        ResolvableType type = ResolvableType.forClass(StandardAnnotationCustomizableTypeExcludeFilter.class, ((Object)((Object)this)).getClass());
        return type.resolveGeneric(new int[0]);
    }

    static {
        AnnotationCustomizableTypeExcludeFilter.FilterType[] filterValues = AnnotationCustomizableTypeExcludeFilter.FilterType.values();
        FILTER_TYPE_ATTRIBUTES = new String[filterValues.length];
        for (int i = 0; i < filterValues.length; ++i) {
            StandardAnnotationCustomizableTypeExcludeFilter.FILTER_TYPE_ATTRIBUTES[i] = filterValues[i].name().toLowerCase() + "Filters";
        }
    }
}

