/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import org.apache.maven.plugin.logging.Log;
import org.springframework.boot.buildpack.platform.build.BuilderDockerConfiguration;
import org.springframework.boot.buildpack.platform.docker.configuration.DockerRegistryAuthentication;

public class Docker {
    private String host;
    private String context;
    private boolean tlsVerify;
    private String certPath;
    private boolean bindHostToBuilder;
    private DockerRegistry builderRegistry;
    private DockerRegistry publishRegistry;

    public String getHost() {
        return this.host;
    }

    void setHost(String host) {
        this.host = host;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public boolean isTlsVerify() {
        return this.tlsVerify;
    }

    void setTlsVerify(boolean tlsVerify) {
        this.tlsVerify = tlsVerify;
    }

    public String getCertPath() {
        return this.certPath;
    }

    void setCertPath(String certPath) {
        this.certPath = certPath;
    }

    public boolean isBindHostToBuilder() {
        return this.bindHostToBuilder;
    }

    void setBindHostToBuilder(boolean bindHostToBuilder) {
        this.bindHostToBuilder = bindHostToBuilder;
    }

    DockerRegistry getBuilderRegistry() {
        return this.builderRegistry;
    }

    void setBuilderRegistry(DockerRegistry builderRegistry) {
        this.builderRegistry = builderRegistry;
    }

    DockerRegistry getPublishRegistry() {
        return this.publishRegistry;
    }

    void setPublishRegistry(DockerRegistry builderRegistry) {
        this.publishRegistry = builderRegistry;
    }

    BuilderDockerConfiguration asDockerConfiguration(Log log, boolean publish) {
        BuilderDockerConfiguration dockerConfiguration = new BuilderDockerConfiguration();
        dockerConfiguration = this.customizeHost(dockerConfiguration);
        dockerConfiguration = dockerConfiguration.withBindHostToBuilder(this.bindHostToBuilder);
        dockerConfiguration = this.customizeBuilderAuthentication(log, dockerConfiguration);
        dockerConfiguration = this.customizePublishAuthentication(log, dockerConfiguration, publish);
        return dockerConfiguration;
    }

    private BuilderDockerConfiguration customizeHost(BuilderDockerConfiguration dockerConfiguration) {
        if (this.context != null && this.host != null) {
            throw new IllegalArgumentException("Invalid Docker configuration, either context or host can be provided but not both");
        }
        if (this.context != null) {
            return dockerConfiguration.withContext(this.context);
        }
        if (this.host != null) {
            return dockerConfiguration.withHost(this.host, this.tlsVerify, this.certPath);
        }
        return dockerConfiguration;
    }

    private BuilderDockerConfiguration customizeBuilderAuthentication(Log log, BuilderDockerConfiguration dockerConfiguration) {
        DockerRegistryAuthentication authentication = DockerRegistryAuthentication.configuration(null, (message, ex) -> log.warn((CharSequence)message));
        return dockerConfiguration.withBuilderRegistryAuthentication(this.getRegistryAuthentication("builder", this.builderRegistry, authentication));
    }

    private BuilderDockerConfiguration customizePublishAuthentication(Log log, BuilderDockerConfiguration dockerConfiguration, boolean publish) {
        if (!publish) {
            return dockerConfiguration;
        }
        DockerRegistryAuthentication authentication = DockerRegistryAuthentication.configuration((DockerRegistryAuthentication)DockerRegistryAuthentication.EMPTY_USER, (message, ex) -> log.warn((CharSequence)message));
        return dockerConfiguration.withPublishRegistryAuthentication(this.getRegistryAuthentication("publish", this.publishRegistry, authentication));
    }

    private DockerRegistryAuthentication getRegistryAuthentication(String type, DockerRegistry registry, DockerRegistryAuthentication fallback) {
        if (registry == null || registry.isEmpty()) {
            return fallback;
        }
        if (registry.hasTokenAuth() && !registry.hasUserAuth()) {
            return DockerRegistryAuthentication.token((String)registry.getToken());
        }
        if (registry.hasUserAuth() && !registry.hasTokenAuth()) {
            return DockerRegistryAuthentication.user((String)registry.getUsername(), (String)registry.getPassword(), (String)registry.getUrl(), (String)registry.getEmail());
        }
        throw new IllegalArgumentException("Invalid Docker " + type + " registry configuration, either token or username/password must be provided");
    }

    public static class DockerRegistry {
        private String username;
        private String password;
        private String url;
        private String email;
        private String token;

        public DockerRegistry() {
        }

        public DockerRegistry(String username, String password, String url, String email) {
            this.username = username;
            this.password = password;
            this.url = url;
            this.email = email;
        }

        public DockerRegistry(String token) {
            this.token = token;
        }

        public String getUsername() {
            return this.username;
        }

        void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        void setPassword(String password) {
            this.password = password;
        }

        public String getEmail() {
            return this.email;
        }

        void setEmail(String email) {
            this.email = email;
        }

        String getUrl() {
            return this.url;
        }

        void setUrl(String url) {
            this.url = url;
        }

        public String getToken() {
            return this.token;
        }

        void setToken(String token) {
            this.token = token;
        }

        boolean isEmpty() {
            return this.username == null && this.password == null && this.url == null && this.email == null && this.token == null;
        }

        boolean hasTokenAuth() {
            return this.token != null;
        }

        boolean hasUserAuth() {
            return this.username != null && this.password != null;
        }
    }
}

