/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.pulsar;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.reactive.client.adapter.AdaptedReactivePulsarClientFactory;
import org.apache.pulsar.reactive.client.adapter.ProducerCacheProvider;
import org.apache.pulsar.reactive.client.api.ReactiveMessageConsumerBuilder;
import org.apache.pulsar.reactive.client.api.ReactiveMessageReaderBuilder;
import org.apache.pulsar.reactive.client.api.ReactiveMessageSenderBuilder;
import org.apache.pulsar.reactive.client.api.ReactiveMessageSenderCache;
import org.apache.pulsar.reactive.client.api.ReactivePulsarClient;
import org.apache.pulsar.reactive.client.producercache.CaffeineShadedProducerCacheProvider;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.pulsar.PulsarAutoConfiguration;
import org.springframework.boot.autoconfigure.pulsar.PulsarConfiguration;
import org.springframework.boot.autoconfigure.pulsar.PulsarProperties;
import org.springframework.boot.autoconfigure.pulsar.PulsarReactivePropertiesMapper;
import org.springframework.boot.util.LambdaSafe;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.pulsar.core.SchemaResolver;
import org.springframework.pulsar.core.TopicResolver;
import org.springframework.pulsar.reactive.config.DefaultReactivePulsarListenerContainerFactory;
import org.springframework.pulsar.reactive.config.annotation.EnableReactivePulsar;
import org.springframework.pulsar.reactive.core.DefaultReactivePulsarConsumerFactory;
import org.springframework.pulsar.reactive.core.DefaultReactivePulsarReaderFactory;
import org.springframework.pulsar.reactive.core.DefaultReactivePulsarSenderFactory;
import org.springframework.pulsar.reactive.core.ReactiveMessageConsumerBuilderCustomizer;
import org.springframework.pulsar.reactive.core.ReactiveMessageReaderBuilderCustomizer;
import org.springframework.pulsar.reactive.core.ReactiveMessageSenderBuilderCustomizer;
import org.springframework.pulsar.reactive.core.ReactivePulsarConsumerFactory;
import org.springframework.pulsar.reactive.core.ReactivePulsarReaderFactory;
import org.springframework.pulsar.reactive.core.ReactivePulsarSenderFactory;
import org.springframework.pulsar.reactive.core.ReactivePulsarTemplate;
import org.springframework.pulsar.reactive.listener.ReactivePulsarContainerProperties;

@AutoConfiguration(after={PulsarAutoConfiguration.class})
@ConditionalOnClass(value={PulsarClient.class, ReactivePulsarClient.class, ReactivePulsarTemplate.class})
@Import(value={PulsarConfiguration.class})
public class PulsarReactiveAutoConfiguration {
    private final PulsarProperties properties;
    private final PulsarReactivePropertiesMapper propertiesMapper;

    PulsarReactiveAutoConfiguration(PulsarProperties properties) {
        this.properties = properties;
        this.propertiesMapper = new PulsarReactivePropertiesMapper(properties);
    }

    @Bean
    @ConditionalOnMissingBean
    ReactivePulsarClient reactivePulsarClient(PulsarClient pulsarClient) {
        return AdaptedReactivePulsarClientFactory.create((PulsarClient)pulsarClient);
    }

    @Bean
    @ConditionalOnMissingBean(value={ProducerCacheProvider.class})
    @ConditionalOnClass(value={CaffeineShadedProducerCacheProvider.class})
    @ConditionalOnProperty(name={"spring.pulsar.producer.cache.enabled"}, havingValue="true", matchIfMissing=true)
    CaffeineShadedProducerCacheProvider reactivePulsarProducerCacheProvider() {
        PulsarProperties.Producer.Cache properties = this.properties.getProducer().getCache();
        return new CaffeineShadedProducerCacheProvider(properties.getExpireAfterAccess(), Duration.ofMinutes(10L), Long.valueOf(properties.getMaximumSize()), Integer.valueOf(properties.getInitialCapacity()));
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"spring.pulsar.producer.cache.enabled"}, havingValue="true", matchIfMissing=true)
    ReactiveMessageSenderCache reactivePulsarMessageSenderCache(ObjectProvider<ProducerCacheProvider> producerCacheProvider) {
        return this.reactivePulsarMessageSenderCache((ProducerCacheProvider)producerCacheProvider.getIfAvailable());
    }

    private ReactiveMessageSenderCache reactivePulsarMessageSenderCache(ProducerCacheProvider producerCacheProvider) {
        return producerCacheProvider != null ? AdaptedReactivePulsarClientFactory.createCache((ProducerCacheProvider)producerCacheProvider) : AdaptedReactivePulsarClientFactory.createCache();
    }

    @Bean
    @ConditionalOnMissingBean(value={ReactivePulsarSenderFactory.class})
    DefaultReactivePulsarSenderFactory<?> reactivePulsarSenderFactory(ReactivePulsarClient reactivePulsarClient, ObjectProvider<ReactiveMessageSenderCache> reactiveMessageSenderCache, TopicResolver topicResolver, ObjectProvider<ReactiveMessageSenderBuilderCustomizer<?>> customizersProvider) {
        ArrayList<Object> customizers = new ArrayList<Object>();
        customizers.add(this.propertiesMapper::customizeMessageSenderBuilder);
        customizers.addAll(customizersProvider.orderedStream().toList());
        List<ReactiveMessageSenderBuilderCustomizer> lambdaSafeCustomizers = List.of(builder -> this.applyMessageSenderBuilderCustomizers(customizers, builder));
        return DefaultReactivePulsarSenderFactory.builderFor((ReactivePulsarClient)reactivePulsarClient).withDefaultConfigCustomizers(lambdaSafeCustomizers).withMessageSenderCache((ReactiveMessageSenderCache)reactiveMessageSenderCache.getIfAvailable()).withTopicResolver(topicResolver).build();
    }

    private void applyMessageSenderBuilderCustomizers(List<ReactiveMessageSenderBuilderCustomizer<?>> customizers, ReactiveMessageSenderBuilder<?> builder) {
        LambdaSafe.callbacks(ReactiveMessageSenderBuilderCustomizer.class, customizers, builder, (Object[])new Object[0]).invoke(customizer -> customizer.customize(builder));
    }

    @Bean
    @ConditionalOnMissingBean(value={ReactivePulsarConsumerFactory.class})
    DefaultReactivePulsarConsumerFactory<?> reactivePulsarConsumerFactory(ReactivePulsarClient pulsarReactivePulsarClient, ObjectProvider<ReactiveMessageConsumerBuilderCustomizer<?>> customizersProvider) {
        ArrayList<Object> customizers = new ArrayList<Object>();
        customizers.add(this.propertiesMapper::customizeMessageConsumerBuilder);
        customizers.addAll(customizersProvider.orderedStream().toList());
        List<ReactiveMessageConsumerBuilderCustomizer> lambdaSafeCustomizers = List.of(builder -> this.applyMessageConsumerBuilderCustomizers(customizers, builder));
        return new DefaultReactivePulsarConsumerFactory(pulsarReactivePulsarClient, lambdaSafeCustomizers);
    }

    private void applyMessageConsumerBuilderCustomizers(List<ReactiveMessageConsumerBuilderCustomizer<?>> customizers, ReactiveMessageConsumerBuilder<?> builder) {
        LambdaSafe.callbacks(ReactiveMessageConsumerBuilderCustomizer.class, customizers, builder, (Object[])new Object[0]).invoke(customizer -> customizer.customize(builder));
    }

    @Bean
    @ConditionalOnMissingBean(name={"reactivePulsarListenerContainerFactory"})
    DefaultReactivePulsarListenerContainerFactory<?> reactivePulsarListenerContainerFactory(ReactivePulsarConsumerFactory<Object> reactivePulsarConsumerFactory, SchemaResolver schemaResolver, TopicResolver topicResolver) {
        ReactivePulsarContainerProperties containerProperties = new ReactivePulsarContainerProperties();
        containerProperties.setSchemaResolver(schemaResolver);
        containerProperties.setTopicResolver(topicResolver);
        this.propertiesMapper.customizeContainerProperties(containerProperties);
        return new DefaultReactivePulsarListenerContainerFactory(reactivePulsarConsumerFactory, containerProperties);
    }

    @Bean
    @ConditionalOnMissingBean(value={ReactivePulsarReaderFactory.class})
    DefaultReactivePulsarReaderFactory<?> reactivePulsarReaderFactory(ReactivePulsarClient reactivePulsarClient, ObjectProvider<ReactiveMessageReaderBuilderCustomizer<?>> customizersProvider) {
        ArrayList<Object> customizers = new ArrayList<Object>();
        customizers.add(this.propertiesMapper::customizeMessageReaderBuilder);
        customizers.addAll(customizersProvider.orderedStream().toList());
        List<ReactiveMessageReaderBuilderCustomizer> lambdaSafeCustomizers = List.of(builder -> this.applyMessageReaderBuilderCustomizers(customizers, builder));
        return new DefaultReactivePulsarReaderFactory(reactivePulsarClient, lambdaSafeCustomizers);
    }

    private void applyMessageReaderBuilderCustomizers(List<ReactiveMessageReaderBuilderCustomizer<?>> customizers, ReactiveMessageReaderBuilder<?> builder) {
        LambdaSafe.callbacks(ReactiveMessageReaderBuilderCustomizer.class, customizers, builder, (Object[])new Object[0]).invoke(customizer -> customizer.customize(builder));
    }

    @Bean
    @ConditionalOnMissingBean
    ReactivePulsarTemplate<?> pulsarReactiveTemplate(ReactivePulsarSenderFactory<?> reactivePulsarSenderFactory, SchemaResolver schemaResolver, TopicResolver topicResolver) {
        return new ReactivePulsarTemplate(reactivePulsarSenderFactory, schemaResolver, topicResolver);
    }

    @Configuration(proxyBeanMethods=false)
    @EnableReactivePulsar
    @ConditionalOnMissingBean(name={"org.springframework.pulsar.config.internalReactivePulsarListenerAnnotationProcessor"})
    static class EnableReactivePulsarConfiguration {
        EnableReactivePulsarConfiguration() {
        }
    }
}

