/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql;

import io.netty.channel.unix.DomainSocketAddress;
import io.r2dbc.postgresql.ConnectionFunction;
import io.r2dbc.postgresql.ConnectionStrategy;
import io.r2dbc.postgresql.MultiHostConnectionStrategy;
import io.r2dbc.postgresql.PostgresqlConnectionConfiguration;
import io.r2dbc.postgresql.SingleHostConnectionFunction;
import io.r2dbc.postgresql.SingleHostConnectionStrategy;
import io.r2dbc.postgresql.SslFallbackConnectionFunction;
import io.r2dbc.postgresql.client.ConnectionSettings;
import io.r2dbc.postgresql.client.MultiHostConfiguration;
import io.r2dbc.postgresql.client.SSLConfig;
import io.r2dbc.postgresql.client.SSLMode;
import io.r2dbc.postgresql.client.SingleHostConfiguration;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;

final class ConnectionStrategyFactory {
    ConnectionStrategyFactory() {
    }

    public static ConnectionStrategy getConnectionStrategy(ConnectionFunction connectionFunction, PostgresqlConnectionConfiguration configuration, ConnectionSettings connectionSettings) {
        return ConnectionStrategyFactory.doGetConnectionStrategy(new SingleHostConnectionFunction(connectionFunction, configuration), configuration, connectionSettings);
    }

    private static ConnectionStrategy doGetConnectionStrategy(ConnectionFunction connectionFunction, PostgresqlConnectionConfiguration configuration, ConnectionSettings connectionSettings) {
        MultiHostConfiguration multiHostConfiguration;
        SSLConfig sslConfig = configuration.getSslConfig();
        if (!SSLMode.DISABLE.equals((Object)sslConfig.getSslMode())) {
            connectionFunction = new SslFallbackConnectionFunction(sslConfig, connectionFunction);
        }
        if ((multiHostConfiguration = configuration.getMultiHostConfiguration()) != null) {
            return new MultiHostConnectionStrategy(connectionFunction, ConnectionStrategyFactory.createSocketAddress(multiHostConfiguration), configuration, connectionSettings);
        }
        return new SingleHostConnectionStrategy(connectionFunction, ConnectionStrategyFactory.createSocketAddress(configuration.getRequiredSingleHostConfiguration()), connectionSettings);
    }

    private static SocketAddress createSocketAddress(SingleHostConfiguration configuration) {
        if (!configuration.isUseSocket()) {
            return InetSocketAddress.createUnresolved(configuration.getRequiredHost(), configuration.getPort());
        }
        return DomainSocketFactory.getDomainSocketAddress(configuration);
    }

    private static List<SocketAddress> createSocketAddress(MultiHostConfiguration configuration) {
        ArrayList<SocketAddress> addressList = new ArrayList<SocketAddress>(configuration.getHosts().size());
        for (MultiHostConfiguration.ServerHost host : configuration.getHosts()) {
            addressList.add(InetSocketAddress.createUnresolved(host.getHost(), host.getPort()));
        }
        return addressList;
    }

    static class DomainSocketFactory {
        DomainSocketFactory() {
        }

        private static SocketAddress getDomainSocketAddress(SingleHostConfiguration configuration) {
            return new DomainSocketAddress(configuration.getRequiredSocket());
        }
    }
}

