/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.client.ml.job.config.Job;
import org.elasticsearch.client.ml.job.process.ModelSnapshot;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class RevertModelSnapshotRequest
extends ActionRequest
implements ToXContentObject {
    public static final ParseField DELETE_INTERVENING = new ParseField("delete_intervening_results", new String[0]);
    public static final ConstructingObjectParser<RevertModelSnapshotRequest, Void> PARSER = new ConstructingObjectParser("revert_model_snapshots_request", a -> new RevertModelSnapshotRequest((String)a[0], (String)a[1]));
    private final String jobId;
    private final String snapshotId;
    private Boolean deleteInterveningResults;

    public RevertModelSnapshotRequest(String jobId, String snapshotId) {
        this.jobId = Objects.requireNonNull(jobId, "[" + Job.ID + "] must not be null");
        this.snapshotId = Objects.requireNonNull(snapshotId, "[" + ModelSnapshot.SNAPSHOT_ID + "] must not be null");
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public Boolean getDeleteInterveningResults() {
        return this.deleteInterveningResults;
    }

    public void setDeleteInterveningResults(Boolean deleteInterveningResults) {
        this.deleteInterveningResults = deleteInterveningResults;
    }

    public ActionRequestValidationException validate() {
        return null;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Job.ID.getPreferredName(), this.jobId);
        builder.field(ModelSnapshot.SNAPSHOT_ID.getPreferredName(), this.snapshotId);
        if (this.deleteInterveningResults != null) {
            builder.field(DELETE_INTERVENING.getPreferredName(), this.deleteInterveningResults);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        RevertModelSnapshotRequest request = (RevertModelSnapshotRequest)((Object)obj);
        return Objects.equals(this.jobId, request.jobId) && Objects.equals(this.snapshotId, request.snapshotId) && Objects.equals(this.deleteInterveningResults, request.deleteInterveningResults);
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.snapshotId, this.deleteInterveningResults);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), Job.ID);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), ModelSnapshot.SNAPSHOT_ID);
        PARSER.declareBoolean(RevertModelSnapshotRequest::setDeleteInterveningResults, DELETE_INTERVENING);
    }
}

