/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.maven.process;

import java.io.File;
import java.util.Optional;
import java.util.function.Consumer;

public class SourceDirectoryFinder {
    public static final String DEFAULT_SOURCE_DIR = "src/docs/asciidoc";
    public static final String[] ORDERED_CANDIDATE_PATHS = new String[]{"src/docs/asciidoc", "src/asciidoc", "src/main/asciidoc"};
    private final String initialCandidate;
    private final File baseDir;
    private final Consumer<File> notFoundAction;

    public SourceDirectoryFinder(File initialCandidate, File baseDir, Consumer<File> notFoundAction) {
        this.initialCandidate = initialCandidate.toString();
        this.baseDir = baseDir;
        this.notFoundAction = notFoundAction;
    }

    public Optional<File> find() {
        if (!this.matchesDefaultSourceDirectory(this.initialCandidate)) {
            File filePath = this.resolvePath(this.initialCandidate);
            if (filePath.exists()) {
                return Optional.of(filePath);
            }
            this.notFoundAction.accept(filePath);
            return Optional.empty();
        }
        for (String candidatePath : ORDERED_CANDIDATE_PATHS) {
            File current = this.resolvePath(candidatePath);
            if (current.exists()) {
                return Optional.of(current);
            }
            this.notFoundAction.accept(current);
        }
        return Optional.empty();
    }

    private boolean matchesDefaultSourceDirectory(String path) {
        return this.resolvePath(path).equals(new File(this.baseDir, DEFAULT_SOURCE_DIR));
    }

    private File resolvePath(String filePath) {
        File candidate = new File(filePath);
        if (candidate.isAbsolute()) {
            return candidate;
        }
        return new File(this.baseDir, filePath);
    }
}

