/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.maven.log;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.asciidoctor.ast.Cursor;
import org.asciidoctor.log.LogRecord;

public class LogRecordHelper {
    private static final String MESSAGE_HEADER = "asciidoctor";

    public static String format(LogRecord logRecord, File sourceDirectory) {
        Cursor cursor = logRecord.getCursor();
        String relativePath = LogRecordHelper.calculateFileRelativePath(cursor, sourceDirectory);
        ArrayList<String> messageParts = new ArrayList<String>();
        messageParts.add(MESSAGE_HEADER);
        messageParts.add(logRecord.getSeverity().toString());
        if (relativePath != null) {
            messageParts.add(relativePath);
        }
        if (cursor != null && cursor.getLineNumber() > 0) {
            messageParts.add("line " + cursor.getLineNumber());
        }
        messageParts.add(logRecord.getMessage());
        return messageParts.stream().collect(Collectors.joining(": "));
    }

    private static String calculateFileRelativePath(Cursor cursor, File sourceDirectory) {
        try {
            if (cursor != null && cursor.getFile() != null) {
                return new File(cursor.getFile()).getCanonicalPath().substring(sourceDirectory.getCanonicalPath().length() + 1);
            }
        }
        catch (IOException e) {
            return cursor.getFile();
        }
        return null;
    }
}

