/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.serialization.LongSerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.state.ValueAndTimestamp;

public class ValueAndTimestampSerializer<V>
implements Serializer<ValueAndTimestamp<V>> {
    public final Serializer<V> valueSerializer;
    private final Serializer<Long> timestampSerializer;

    ValueAndTimestampSerializer(Serializer<V> valueSerializer) {
        Objects.requireNonNull(valueSerializer);
        this.valueSerializer = valueSerializer;
        this.timestampSerializer = new LongSerializer();
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.valueSerializer.configure(configs, isKey);
        this.timestampSerializer.configure(configs, isKey);
    }

    public byte[] serialize(String topic, ValueAndTimestamp<V> data) {
        if (data == null) {
            return null;
        }
        return this.serialize(topic, data.value(), data.timestamp());
    }

    public byte[] serialize(String topic, V data, long timestamp) {
        if (data == null) {
            return null;
        }
        byte[] rawValue = this.valueSerializer.serialize(topic, data);
        byte[] rawTimestamp = this.timestampSerializer.serialize(topic, (Object)timestamp);
        return ByteBuffer.allocate(rawTimestamp.length + rawValue.length).put(rawTimestamp).put(rawValue).array();
    }

    public void close() {
        this.valueSerializer.close();
        this.timestampSerializer.close();
    }
}

