/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.internals.RocksDBStore;
import org.apache.kafka.streams.state.internals.RocksDBTimestampedStore;

public class RocksDbKeyValueBytesStoreSupplier
implements KeyValueBytesStoreSupplier {
    private final String name;
    private final boolean returnTimestampedStore;

    public RocksDbKeyValueBytesStoreSupplier(String name, boolean returnTimestampedStore) {
        this.name = name;
        this.returnTimestampedStore = returnTimestampedStore;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public KeyValueStore<Bytes, byte[]> get() {
        return this.returnTimestampedStore ? new RocksDBTimestampedStore(this.name) : new RocksDBStore(this.name);
    }

    @Override
    public String metricsScope() {
        return "rocksdb-state";
    }
}

