/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.ProcessorStateException;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.CacheFlushListener;
import org.apache.kafka.streams.state.internals.CachedStateStore;
import org.apache.kafka.streams.state.internals.WrappedStateStore;
import org.apache.kafka.streams.state.internals.metrics.Sensors;

public class MeteredKeyValueStore<K, V>
extends WrappedStateStore<KeyValueStore<Bytes, byte[]>, K, V>
implements KeyValueStore<K, V> {
    final Serde<K> keySerde;
    final Serde<V> valueSerde;
    StateSerdes<K, V> serdes;
    private final String metricScope;
    protected final Time time;
    private Sensor putTime;
    private Sensor putIfAbsentTime;
    private Sensor getTime;
    private Sensor deleteTime;
    private Sensor putAllTime;
    private Sensor allTime;
    private Sensor rangeTime;
    private Sensor flushTime;
    private StreamsMetricsImpl metrics;
    private String taskName;

    MeteredKeyValueStore(KeyValueStore<Bytes, byte[]> inner, String metricScope, Time time, Serde<K> keySerde, Serde<V> valueSerde) {
        super(inner);
        this.metricScope = metricScope;
        this.time = time != null ? time : Time.SYSTEM;
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
    }

    @Override
    public void init(ProcessorContext context, StateStore root) {
        this.metrics = (StreamsMetricsImpl)context.metrics();
        this.taskName = context.taskId().toString();
        String metricsGroup = "stream-" + this.metricScope + "-metrics";
        Map<String, String> taskTags = this.metrics.tagMap("task-id", this.taskName, this.metricScope + "-id", "all");
        Map<String, String> storeTags = this.metrics.tagMap("task-id", this.taskName, this.metricScope + "-id", this.name());
        this.initStoreSerde(context);
        this.putTime = Sensors.createTaskAndStoreLatencyAndThroughputSensors(Sensor.RecordingLevel.DEBUG, "put", this.metrics, metricsGroup, this.taskName, this.name(), taskTags, storeTags);
        this.putIfAbsentTime = Sensors.createTaskAndStoreLatencyAndThroughputSensors(Sensor.RecordingLevel.DEBUG, "put-if-absent", this.metrics, metricsGroup, this.taskName, this.name(), taskTags, storeTags);
        this.putAllTime = Sensors.createTaskAndStoreLatencyAndThroughputSensors(Sensor.RecordingLevel.DEBUG, "put-all", this.metrics, metricsGroup, this.taskName, this.name(), taskTags, storeTags);
        this.getTime = Sensors.createTaskAndStoreLatencyAndThroughputSensors(Sensor.RecordingLevel.DEBUG, "get", this.metrics, metricsGroup, this.taskName, this.name(), taskTags, storeTags);
        this.allTime = Sensors.createTaskAndStoreLatencyAndThroughputSensors(Sensor.RecordingLevel.DEBUG, "all", this.metrics, metricsGroup, this.taskName, this.name(), taskTags, storeTags);
        this.rangeTime = Sensors.createTaskAndStoreLatencyAndThroughputSensors(Sensor.RecordingLevel.DEBUG, "range", this.metrics, metricsGroup, this.taskName, this.name(), taskTags, storeTags);
        this.flushTime = Sensors.createTaskAndStoreLatencyAndThroughputSensors(Sensor.RecordingLevel.DEBUG, "flush", this.metrics, metricsGroup, this.taskName, this.name(), taskTags, storeTags);
        this.deleteTime = Sensors.createTaskAndStoreLatencyAndThroughputSensors(Sensor.RecordingLevel.DEBUG, "delete", this.metrics, metricsGroup, this.taskName, this.name(), taskTags, storeTags);
        Sensor restoreTime = Sensors.createTaskAndStoreLatencyAndThroughputSensors(Sensor.RecordingLevel.DEBUG, "restore", this.metrics, metricsGroup, this.taskName, this.name(), taskTags, storeTags);
        if (restoreTime.shouldRecord()) {
            this.measureLatency(() -> {
                super.init(context, root);
                return null;
            }, restoreTime);
        } else {
            super.init(context, root);
        }
    }

    void initStoreSerde(ProcessorContext context) {
        this.serdes = new StateSerdes(ProcessorStateManager.storeChangelogTopic(context.applicationId(), this.name()), (Serde<?>)(this.keySerde == null ? context.keySerde() : this.keySerde), (Serde<?>)(this.valueSerde == null ? context.valueSerde() : this.valueSerde));
    }

    @Override
    public boolean setFlushListener(CacheFlushListener<K, V> listener, boolean sendOldValues) {
        KeyValueStore wrapped = (KeyValueStore)this.wrapped();
        if (wrapped instanceof CachedStateStore) {
            return ((CachedStateStore)((Object)wrapped)).setFlushListener((rawKey, rawNewValue, rawOldValue, timestamp) -> listener.apply(this.serdes.keyFrom((byte[])rawKey), rawNewValue != null ? (Object)this.serdes.valueFrom((byte[])rawNewValue) : null, rawOldValue != null ? (Object)this.serdes.valueFrom((byte[])rawOldValue) : null, timestamp), sendOldValues);
        }
        return false;
    }

    @Override
    public V get(K key) {
        try {
            if (this.getTime.shouldRecord()) {
                return (V)this.measureLatency(() -> this.outerValue((byte[])((KeyValueStore)this.wrapped()).get(this.keyBytes(key))), this.getTime);
            }
            return this.outerValue((byte[])((KeyValueStore)this.wrapped()).get(this.keyBytes(key)));
        }
        catch (ProcessorStateException e) {
            String message = String.format(e.getMessage(), key);
            throw new ProcessorStateException(message, (Throwable)((Object)e));
        }
    }

    @Override
    public void put(K key, V value) {
        try {
            if (this.putTime.shouldRecord()) {
                this.measureLatency(() -> {
                    ((KeyValueStore)this.wrapped()).put(this.keyBytes(key), this.serdes.rawValue(value));
                    return null;
                }, this.putTime);
            } else {
                ((KeyValueStore)this.wrapped()).put(this.keyBytes(key), this.serdes.rawValue(value));
            }
        }
        catch (ProcessorStateException e) {
            String message = String.format(e.getMessage(), key, value);
            throw new ProcessorStateException(message, (Throwable)((Object)e));
        }
    }

    @Override
    public V putIfAbsent(K key, V value) {
        if (this.putIfAbsentTime.shouldRecord()) {
            return (V)this.measureLatency(() -> this.outerValue(((KeyValueStore)this.wrapped()).putIfAbsent(this.keyBytes(key), this.serdes.rawValue(value))), this.putIfAbsentTime);
        }
        return this.outerValue(((KeyValueStore)this.wrapped()).putIfAbsent(this.keyBytes(key), this.serdes.rawValue(value)));
    }

    @Override
    public void putAll(List<KeyValue<K, V>> entries) {
        if (this.putAllTime.shouldRecord()) {
            this.measureLatency(() -> {
                ((KeyValueStore)this.wrapped()).putAll(this.innerEntries(entries));
                return null;
            }, this.putAllTime);
        } else {
            ((KeyValueStore)this.wrapped()).putAll(this.innerEntries(entries));
        }
    }

    @Override
    public V delete(K key) {
        try {
            if (this.deleteTime.shouldRecord()) {
                return (V)this.measureLatency(() -> this.outerValue((byte[])((KeyValueStore)this.wrapped()).delete(this.keyBytes(key))), this.deleteTime);
            }
            return this.outerValue((byte[])((KeyValueStore)this.wrapped()).delete(this.keyBytes(key)));
        }
        catch (ProcessorStateException e) {
            String message = String.format(e.getMessage(), key);
            throw new ProcessorStateException(message, (Throwable)((Object)e));
        }
    }

    @Override
    public KeyValueIterator<K, V> range(K from, K to) {
        return new MeteredKeyValueIterator(((KeyValueStore)this.wrapped()).range(Bytes.wrap((byte[])this.serdes.rawKey(from)), Bytes.wrap((byte[])this.serdes.rawKey(to))), this.rangeTime);
    }

    @Override
    public KeyValueIterator<K, V> all() {
        return new MeteredKeyValueIterator(((KeyValueStore)this.wrapped()).all(), this.allTime);
    }

    @Override
    public void flush() {
        if (this.flushTime.shouldRecord()) {
            this.measureLatency(() -> {
                super.flush();
                return null;
            }, this.flushTime);
        } else {
            super.flush();
        }
    }

    @Override
    public long approximateNumEntries() {
        return ((KeyValueStore)this.wrapped()).approximateNumEntries();
    }

    @Override
    public void close() {
        super.close();
        this.metrics.removeAllStoreLevelSensors(this.taskName, this.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V measureLatency(Action<V> action, Sensor sensor) {
        long startNs = this.time.nanoseconds();
        try {
            V v = action.execute();
            return v;
        }
        finally {
            this.metrics.recordLatency(sensor, startNs, this.time.nanoseconds());
        }
    }

    private V outerValue(byte[] value) {
        return value != null ? (V)this.serdes.valueFrom(value) : null;
    }

    private Bytes keyBytes(K key) {
        return Bytes.wrap((byte[])this.serdes.rawKey(key));
    }

    private List<KeyValue<Bytes, byte[]>> innerEntries(List<KeyValue<K, V>> from) {
        ArrayList<KeyValue<Bytes, byte[]>> byteEntries = new ArrayList<KeyValue<Bytes, byte[]>>();
        for (KeyValue<K, V> entry : from) {
            byteEntries.add(KeyValue.pair(Bytes.wrap((byte[])this.serdes.rawKey(entry.key)), this.serdes.rawValue(entry.value)));
        }
        return byteEntries;
    }

    private class MeteredKeyValueIterator
    implements KeyValueIterator<K, V> {
        private final KeyValueIterator<Bytes, byte[]> iter;
        private final Sensor sensor;
        private final long startNs;

        private MeteredKeyValueIterator(KeyValueIterator<Bytes, byte[]> iter, Sensor sensor) {
            this.iter = iter;
            this.sensor = sensor;
            this.startNs = MeteredKeyValueStore.this.time.nanoseconds();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public KeyValue<K, V> next() {
            KeyValue keyValue = (KeyValue)this.iter.next();
            return KeyValue.pair(MeteredKeyValueStore.this.serdes.keyFrom(((Bytes)keyValue.key).get()), MeteredKeyValueStore.this.outerValue((byte[])keyValue.value));
        }

        @Override
        public void remove() {
            this.iter.remove();
        }

        @Override
        public void close() {
            try {
                this.iter.close();
            }
            finally {
                MeteredKeyValueStore.this.metrics.recordLatency(this.sensor, this.startNs, MeteredKeyValueStore.this.time.nanoseconds());
            }
        }

        @Override
        public K peekNextKey() {
            return MeteredKeyValueStore.this.serdes.keyFrom(this.iter.peekNextKey().get());
        }
    }

    private static interface Action<V> {
        public V execute();
    }
}

