/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.util;

import ar.com.fdvs.dj.domain.DJHyperLink;
import ar.com.fdvs.dj.domain.DynamicJasperDesign;
import ar.com.fdvs.dj.domain.StringExpression;
import ar.com.fdvs.dj.util.ExpressionUtils;
import ar.com.fdvs.dj.util.LayoutUtils;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignChart;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignImage;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HyperLinkUtil {
    static final Log log = LogFactory.getLog(HyperLinkUtil.class);

    public static void applyHyperLinkToElement(DynamicJasperDesign design, DJHyperLink djlink, JRDesignImage image, String name) {
        StringExpression hce = djlink.getExpression();
        String text = ExpressionUtils.createCustomExpressionInvocationText(djlink.getExpression(), name);
        LayoutUtils.registerCustomExpressionParameter(design, name, hce);
        JRDesignExpression hlpe = new JRDesignExpression();
        hlpe.setValueClassName(hce.getClassName());
        hlpe.setText(text);
        image.setHyperlinkReferenceExpression((JRExpression)hlpe);
        image.setHyperlinkType(HyperlinkTypeEnum.REFERENCE);
        if (djlink.getTooltip() != null) {
            StringExpression sExp = djlink.getTooltip();
            String tooltipParameterName = "hyperlink_tooltip_" + name;
            String tooltipText = ExpressionUtils.createCustomExpressionInvocationText(djlink.getExpression(), tooltipParameterName);
            LayoutUtils.registerCustomExpressionParameter(design, tooltipParameterName, sExp);
            JRDesignExpression tooltipExp = new JRDesignExpression();
            tooltipExp.setValueClassName(sExp.getClassName());
            tooltipExp.setText(tooltipText);
            image.setHyperlinkTooltipExpression((JRExpression)tooltipExp);
        }
    }

    public static void applyHyperLinkToElement(DynamicJasperDesign design, DJHyperLink djlink, JRDesignTextField textField, String name) {
        StringExpression hce = djlink.getExpression();
        String text = ExpressionUtils.createCustomExpressionInvocationText2(name);
        LayoutUtils.registerCustomExpressionParameter(design, name, hce);
        JRDesignExpression hlpe = new JRDesignExpression();
        hlpe.setValueClassName(hce.getClassName());
        hlpe.setText(text);
        textField.setHyperlinkReferenceExpression((JRExpression)hlpe);
        textField.setHyperlinkType(HyperlinkTypeEnum.REFERENCE);
        if (djlink.getTooltip() != null) {
            StringExpression sExp = djlink.getTooltip();
            String tooltipParameterName = "tooltip_" + name;
            String tooltipText = ExpressionUtils.createCustomExpressionInvocationText2(tooltipParameterName);
            LayoutUtils.registerCustomExpressionParameter(design, tooltipParameterName, sExp);
            JRDesignExpression tooltipExp = new JRDesignExpression();
            tooltipExp.setValueClassName(sExp.getClassName());
            tooltipExp.setText(tooltipText);
            textField.setHyperlinkTooltipExpression((JRExpression)tooltipExp);
        }
    }

    public static void applyHyperLinkToElement(DynamicJasperDesign design, DJHyperLink djlink, JRDesignChart chart, String name) {
        JRDesignExpression hlpe = ExpressionUtils.createAndRegisterExpression(design, name, djlink.getExpression());
        chart.setHyperlinkReferenceExpression((JRExpression)hlpe);
        chart.setHyperlinkType(HyperlinkTypeEnum.REFERENCE);
        if (djlink.getTooltip() != null) {
            JRDesignExpression tooltipExp = ExpressionUtils.createAndRegisterExpression(design, "tooltip_" + name, djlink.getTooltip());
            chart.setHyperlinkTooltipExpression((JRExpression)tooltipExp);
        }
    }
}

